/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class StdInputReader {
    private List<SQLRequestListener> listeners = new ArrayList<SQLRequestListener>();
    private BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(System.in));

    public void startReadLoop() {
        try {
            String nextLine;
            while ((nextLine = this.inputBuffer.readLine()) != null) {
                nextLine = nextLine.replaceAll("\\n", "\n");
                this.sendEvent(nextLine);
            }
        }
        catch (IOException ex) {
            System.err.println("IO exception: " + ex);
        }
    }

    private void sendEvent(String sqlRequest) {
        SQLRequest request;
        long startTime = System.currentTimeMillis();
        try {
            JSONObject val = (JSONObject)JSONValue.parse((String)sqlRequest);
            request = new SQLRequest();
            request.msgId = (Integer)val.get((Object)"msgId");
            request.sql = (String)val.get((Object)"sql");
            request.javaStartTime = startTime;
        }
        catch (Exception e) {
            request = null;
        }
        if (request == null || request.sql == null) {
            System.err.println("Error parsing json not a valid SQLRequest object. " + sqlRequest);
            return;
        }
        for (SQLRequestListener l : this.listeners) {
            l.sqlRequest(request);
        }
    }

    public boolean addListener(SQLRequestListener l) {
        if (this.listeners.contains(l)) {
            return false;
        }
        this.listeners.add(l);
        return true;
    }

    public boolean removeListener(SQLRequestListener l) {
        return this.listeners.remove(l);
    }
}

